/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.pack;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.kinetics.fan.processing.SplashingRecipe;
import com.zurrtum.create.content.kinetics.saw.CuttingRecipe;
import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import com.zurrtum.create.foundation.data.recipe.Mods;
import com.zurrtum.create.foundation.pack.DynamicPack;
import com.zurrtum.create.foundation.pack.EmptyJsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2292;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7475;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class RuntimeDataGenerator {
    private static final Set<String> IGNORES = Set.of("minecraft", "create");
    private static final Pattern STRIPPED_WOODS_PREFIX_REGEX = Pattern.compile("(\\w*)??stripped_(\\w*)(_log|_wood|_stem|_hyphae|_block|(?<!_)wood)()$");
    private static final Pattern STRIPPED_WOOD_SUFFIX_REGEX = Pattern.compile("(\\w*)(_log|_wood|_stem|_hyphae|_block|(?<!_)wood)(\\w*)_stripped(\\w*)");
    private static final Pattern NON_STRIPPED_WOODS_REGEX = Pattern.compile("^(?!stripped_)([a-z_]+)(_log|_wood|_stem|_hyphae|(?<!bioshroom)_block)(([a-z_]+)(?<!_stripped))?$");
    private static final Multimap<class_2960, class_3497> TAGS = HashMultimap.create();
    private static final Object2ObjectOpenHashMap<class_2960, JsonElement> JSON_FILES = new Object2ObjectOpenHashMap();
    private static final Map<class_2960, class_2960> MISMATCHED_WOOD_NAMES = ImmutableMap.builder().put((Object)Mods.ARS_N.asResource("blue_archwood"), (Object)Mods.ARS_N.asResource("archwood")).put((Object)Mods.DD.asResource("blooming"), (Object)Mods.DD.asResource("bloom")).build();

    public static void insertIntoPack(DynamicPack dynamicPack) {
        class_2960 cuttingId = class_7923.field_41188.method_10221(AllRecipeTypes.CUTTING);
        class_2960 splashingId = class_7923.field_41188.method_10221(AllRecipeTypes.SPLASHING);
        for (class_2960 class_29602 : class_7923.field_41178.method_10235()) {
            if (IGNORES.contains(class_29602.method_12836())) continue;
            RuntimeDataGenerator.cuttingRecipes(cuttingId, class_29602);
            RuntimeDataGenerator.washingRecipes(splashingId, class_29602);
        }
        if (!JSON_FILES.isEmpty()) {
            Create.LOGGER.info("Created {} recipes which will be injected into the game", (Object)JSON_FILES.size());
            JSON_FILES.forEach(dynamicPack::put);
            JSON_FILES.clear();
            JSON_FILES.trim();
        }
        if (!TAGS.isEmpty()) {
            Create.LOGGER.info("Created {} tags which will be injected into the game", (Object)TAGS.size());
            for (Map.Entry entry : TAGS.asMap().entrySet()) {
                class_7475 tagFile = new class_7475(new ArrayList((Collection)entry.getValue()), false);
                dynamicPack.put(((class_2960)entry.getKey()).method_45138("tags/item/"), (JsonElement)class_7475.field_39269.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)tagFile).result().orElseThrow());
            }
            TAGS.clear();
        }
    }

    private static void cuttingRecipes(class_2960 typeId, class_2960 itemId) {
        boolean hasFoundMatch;
        String path = itemId.method_12832();
        Matcher match = STRIPPED_WOODS_PREFIX_REGEX.matcher(path);
        boolean strippedInPrefix = hasFoundMatch = match.find();
        if (!hasFoundMatch) {
            match = STRIPPED_WOOD_SUFFIX_REGEX.matcher(path);
            hasFoundMatch = match.find();
        }
        boolean noStrippedVariant = false;
        if (!(hasFoundMatch || class_7923.field_41178.method_10250(itemId.method_45138("stripped_")) || class_7923.field_41178.method_10250(itemId.method_48331("_stripped")))) {
            match = NON_STRIPPED_WOODS_REGEX.matcher(path);
            hasFoundMatch = match.find();
            noStrippedVariant = true;
        }
        if (hasFoundMatch) {
            int planksCount;
            String prefix = strippedInPrefix && match.group(1) != null ? match.group(1) : "";
            String suffix = !strippedInPrefix && !noStrippedVariant ? match.group(3) + match.group(4) : "";
            String type = match.group(strippedInPrefix ? 3 : 2);
            class_2960 matched_name = itemId.method_45136(match.group(strippedInPrefix ? 2 : 1));
            class_2960 base = matched_name.method_48331(type.equals("wood") ? "wood" : "");
            base = MISMATCHED_WOOD_NAMES.getOrDefault(base, base);
            class_2960 nonStrippedId = matched_name.method_48331(type).method_45138(prefix).method_48331(suffix);
            class_2960 planksId = base.method_48331("_planks");
            class_2960 stairsId = base.method_48331(base.method_12836().equals(Mods.BTN.getId()) ? "_planks_stairs" : "_stairs");
            class_2960 slabId = base.method_48331(base.method_12836().equals(Mods.BTN.getId()) ? "_planks_slab" : "_slab");
            class_2960 fenceId = base.method_48331("_fence");
            class_2960 fenceGateId = base.method_48331("_fence_gate");
            class_2960 doorId = base.method_48331("_door");
            class_2960 trapdoorId = base.method_48331("_trapdoor");
            class_2960 pressurePlateId = base.method_48331("_pressure_plate");
            class_2960 buttonId = base.method_48331("_button");
            class_2960 signId = base.method_48331("_sign");
            int n = planksCount = type.contains("block") ? 3 : 6;
            if (!noStrippedVariant) {
                if (class_7923.field_41178.method_10250(nonStrippedId)) {
                    RuntimeDataGenerator.simpleWoodRecipe(typeId, nonStrippedId, itemId);
                }
                RuntimeDataGenerator.simpleWoodRecipe(typeId, itemId, planksId, planksCount);
            } else if (class_7923.field_41178.method_10250(planksId)) {
                class_2960 tag = class_2960.method_60655((String)"create", (String)("runtime_generated/compat/" + itemId.method_12836() + "/" + base.method_12832()));
                RuntimeDataGenerator.insertIntoTag(tag, itemId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, (class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tag), planksId, planksCount);
            }
            if (!path.contains("_wood") && !path.contains("_hyphae") && class_7923.field_41178.method_10250(planksId)) {
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, stairsId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, slabId, 2);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, fenceId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, fenceGateId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, doorId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, trapdoorId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, pressurePlateId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, buttonId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, signId);
            }
        }
    }

    private static void washingRecipes(class_2960 typeId, class_2960 itemId) {
        class_2248 block = (class_2248)class_7923.field_41175.method_63535(itemId);
        if (block instanceof class_2292) {
            class_2292 concretePowderBlock = (class_2292)block;
            RuntimeDataGenerator.simpleSplashingRecipe(typeId, itemId, class_7923.field_41175.method_10221((Object)concretePowderBlock.field_10810));
        }
    }

    private static void insertIntoTag(class_2960 tag, class_2960 itemId) {
        if (class_7923.field_41178.method_10250(itemId)) {
            TAGS.put((Object)tag, (Object)class_3497.method_43942((class_2960)itemId));
        }
    }

    private static void simpleWoodRecipe(class_2960 typeId, class_2960 inputId, class_2960 outputId) {
        RuntimeDataGenerator.simpleWoodRecipe(typeId, inputId, outputId, 1);
    }

    private static void simpleWoodRecipe(class_2960 typeId, class_2960 inputId, class_2960 outputId, int amount) {
        if (class_7923.field_41178.method_10250(outputId)) {
            RuntimeDataGenerator.addRecipe(typeId, inputId.method_12836(), inputId.method_12832(), outputId.method_12832(), new CuttingRecipe(50, List.of(new ProcessingOutput((class_6880<class_1792>)((class_6880)class_7923.field_41178.method_10223(outputId).orElseThrow()), amount)), class_1856.method_8101((class_1935)((class_1935)class_7923.field_41178.method_63535(inputId)))));
        }
    }

    private static void simpleWoodRecipe(class_2960 typeId, class_6862<class_1792> inputTag, class_2960 outputId, int amount) {
        if (class_7923.field_41178.method_10250(outputId)) {
            class_1860.field_47319.encodeStart((DynamicOps)EmptyJsonOps.INSTANCE, (Object)new CuttingRecipe(50, List.of(new ProcessingOutput((class_6880<class_1792>)((class_6880)class_7923.field_41178.method_10223(outputId).orElseThrow()), amount)), EmptyJsonOps.ofTag(inputTag))).ifSuccess(json -> {
                class_2960 inputId = inputTag.comp_327();
                class_2960 path = class_2960.method_60655((String)typeId.method_12836(), (String)("recipe/" + typeId.method_12832() + "/runtime_generated/compat/" + inputId.method_12836() + "/tag_" + inputId.method_12832() + "_to_" + outputId.method_12832()));
                JSON_FILES.put((Object)path, json);
            });
        }
    }

    private static void simpleSplashingRecipe(class_2960 typeId, class_2960 first, class_2960 second) {
        RuntimeDataGenerator.addRecipe(typeId, first.method_12836(), first.method_12832(), second.method_12832(), new SplashingRecipe(List.of(new ProcessingOutput((class_2248)class_7923.field_41175.method_63535(second), 1)), class_1856.method_8101((class_1935)((class_1935)class_7923.field_41175.method_63535(first)))));
    }

    private static void addRecipe(class_2960 typeId, String modid, String from, String to, class_1860<?> recipe) {
        class_1860.field_47319.encodeStart((DynamicOps)JsonOps.INSTANCE, recipe).ifSuccess(json -> {
            class_2960 path = class_2960.method_60655((String)typeId.method_12836(), (String)("recipe/" + typeId.method_12832() + "/runtime_generated/compat/" + modid + "/" + from + "_to_" + to));
            JSON_FILES.put((Object)path, json);
        });
    }
}

